
#include "gravityObj.h"
#include "input.h"
#include "camera.h"
#include "renderer.h"
#include "manager.h"
#include "debugStr.h"
#include "modelManager.h"
#include "sceneModel.h"
#include "texManager.h"
#include "sceneField.h"

//=============================================================================
// CGravityObj::
//=============================================================================
void CGravityObj::Init(void)
{
	// eNX̏
	CSceneModel::Init();

	m_move = D3DXVECTOR3(0.f, 0.f, 0.f);		// ړ
	m_posOldY = 0.f;
	m_jump = true;
}

//=============================================================================
// CGravityObj::I
//=============================================================================
void CGravityObj::Uninit(void)
{
	// eNX̏I
	CSceneModel::Uninit();
}

//=============================================================================
// CGravityObj::XV
//=============================================================================
void CGravityObj::Update(void)
{
	// eNX̍XV
	CSceneModel::Update();

	// nʂƂ̍m肵ꍇ͗Ȃ
	float y = GetPos().y; 
	if (m_posOldY != y)
	{
		m_jump = true;
	}

	if (m_jump == true)
	{
		m_move.y -= 0.1f;		// III
		AddPos(m_move);			// ړʂ̉Z

		// Փ˔
		for (int n = 0; n < MAX_SCENE_PRIORITY; n++)
		{
			std::list<CScene*> *lisScene = CScene::GetScene(n);
			for (CScene* pScene : *lisScene)
			{
				if (pScene == nullptr)continue;
				// ^Cv̎擾
				CScene::OBJTYPE objType = pScene->GetObjType();

				// tB[h̏ꍇ
				if (objType == CScene::OBJTYPE::FIELD)
				{
					// _ELXg
					CSceneField *pField = ((CSceneField*)pScene);
					D3DXVECTOR3 gObjPos = GetPos();
					bool hit;
					float fieldY = pField->GetHeight(gObjPos, &hit);
					if (!hit)
					{
						//					this->Release();
						//					return;
					}
					if (gObjPos.y < fieldY)
					{
						SetPos(D3DXVECTOR3(gObjPos.x, fieldY, gObjPos.z));
						m_move.y = 0.f;
						m_jump = false;
						m_posOldY = fieldY;
						break;
					}
				}
			}
		}
	}
}

//=============================================================================
// CGravityObj::`揈
//=============================================================================
void CGravityObj::Draw(void)
{
	// eNX̕`
	CSceneModel::Draw();
}

// -------- -------- -------- -------- -------- -------- -------- --------
// 쐬
// -------- -------- -------- -------- -------- -------- -------- --------
CGravityObj *CGravityObj::Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rotY, const D3DXVECTOR3 &scl, const std::string &strFilePass)
{
	// CScene3D̐
	CGravityObj *pPlayer = new CGravityObj();
	pPlayer->Init();

	pPlayer->SetPos(pos);
	pPlayer->SetRot(rotY);
	pPlayer->SetScl(scl);
	pPlayer->SetFilePass(strFilePass);

	//---------------------
	// f̃Zbg
	//---------------------
	CManager::GetModelManager()->SetModel(strFilePass);

	//---------------------
	// eNX`̃Zbg
	//---------------------
	D3DXMATERIAL* pMat = CManager::GetModelManager()->GetModelMat(strFilePass);
	for (int nCntMat = 0; nCntMat < (int)CManager::GetModelManager()->GetModelNumMat(strFilePass); nCntMat++)
	{
		// gpĂeNX`Γǂݍ
		if (pMat[nCntMat].pTextureFilename != nullptr && lstrlen(pMat[nCntMat].pTextureFilename) > 0)
		{
			CManager::GetTexManager()->SetTex(pMat[nCntMat].pTextureFilename);
		}
		else { pMat[nCntMat].pTextureFilename = nullptr; }
	}

	return pPlayer;
}